/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWLogQuery;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObjectNumber;
import java.util.Vector;

public final class VWWorkflowMilestones {
    private Vector m_milestoneList = new Vector();
    private VWLog m_eventLog = null;
    private VWLogQuery m_logQuery = null;
    private int m_index = -1;
    private VWMilestoneDefinition[] m_milestoneDefs = null;

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    protected VWWorkflowMilestones(VWSession serviceSession, String workFlowNumber, VWMilestoneDefinition[] theMilestoneDefs, String eventLogName, int theLevel) throws VWException {
        if (workFlowNumber == null || workFlowNumber.length() == 0) {
            throw new VWException("vw.api.VWWorkflowMilestonesBadWorkflowNumber", "Attempt to fetch milestone history with null or empty Workflow number.");
        }
        if (eventLogName == null || eventLogName.length() == 0) {
            throw new VWException("vw.api.VWWorkflowMilestonesBadLogName", "Attempt to fetch milestone history with null or empty event log name.");
        }
        serviceSession.checkSession();
        this.m_eventLog = serviceSession.fetchEventLog(eventLogName);
        boolean isIndex = false;
        String indexName = null;
        VWLogDefinition logDef = this.m_eventLog.fetchLogDefinition();
        if (logDef != null) {
            VWIndexDefinition[] indexDefs = logDef.getIndexes();
            int count = 0;
            if (indexDefs != null) {
                count = indexDefs.length;
            }
            for (int i = 0; i < count && !isIndex; ++i) {
                String[] fieldNames = indexDefs[i].getAuthoredFieldNames();
                if (fieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                indexName = indexDefs[i].getAuthoredName();
                isIndex = true;
            }
        }
        Object logQuery = null;
        if (isIndex) {
            Object[] minValues = new Object[]{workFlowNumber};
            Object[] maxValues = new Object[]{workFlowNumber};
            Object[] subVars0 = new Object[]{new Integer(125), new Integer(theLevel)};
            this.m_logQuery = this.m_eventLog.startQuery(indexName, minValues, maxValues, 96, " F_EventType = :b AND F_MachineId <= :c", subVars0);
        } else {
            Object[] subVars = new Object[]{new VWWorkObjectNumber(workFlowNumber), new Integer(125), new Integer(theLevel)};
            indexName = "F_LogTime";
            this.m_logQuery = this.m_eventLog.startQuery(indexName, null, null, 0, "F_WorkFlowNumber = :a AND  F_EventType = :b  AND F_MachineId <= :c", subVars);
        }
        if (this.m_logQuery != null) {
            while (this.m_logQuery.hasNext()) {
                VWLogElement logElement = this.m_logQuery.next();
                if (logElement == null) continue;
                this.m_milestoneList.addElement(new VWMilestoneElement(theMilestoneDefs, logElement));
            }
            if (this.m_milestoneList.size() > 0) {
                this.m_index = 0;
            }
        }
        this.m_eventLog = null;
        this.m_logQuery = null;
    }

    public void resetFetch() {
        this.m_index = this.m_milestoneList.size() > 0 ? 0 : -1;
    }

    public boolean hasNext() throws VWException {
        return this.m_index != -1 && this.m_index < this.m_milestoneList.size();
    }

    public VWMilestoneElement next() throws VWException {
        if (this.m_index != -1 && this.m_index < this.m_milestoneList.size()) {
            VWMilestoneElement MS = (VWMilestoneElement)this.m_milestoneList.elementAt(this.m_index++);
            return MS;
        }
        return null;
    }
}

